/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.ui.UIObjectsPropertyLabelKeys;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class TableData
implements Serializable {
    private List maxColumnKeys;
    private List columnKeys;
    private boolean intersectColumns;
    private Object defaultCellObject;
    private List rowIds;
    private Map rows;

    public TableData(List maxColumnKeys, List rowPropertyMaps, boolean intersectColumns, Object defaultCellObject) {
        this.maxColumnKeys = maxColumnKeys;
        this.columnKeys = new ArrayList(0);
        this.intersectColumns = intersectColumns;
        this.defaultCellObject = defaultCellObject;
        this.rowIds = new ArrayList(rowPropertyMaps.size());
        this.rows = new HashMap((int)((double)rowPropertyMaps.size() * 1.5), 0.75f);
        Map properties = null;
        String id = null;
        Iterator i = rowPropertyMaps.iterator();
        while (i.hasNext()) {
            properties = (Map)i.next();
            id = (String)properties.get("id");
            if (id == null) {
                throw new IllegalArgumentException("TableData: row's property map does not have an id!");
            }
            this.rowIds.add(id);
            this.rows.put(id, properties);
        }
        this.resetColumnKeys();
    }

    public boolean removeRow(String id) {
        if (this.rowIds.remove(id)) {
            this.rows.remove(id);
            return this.resetColumnKeys();
        }
        return false;
    }

    public boolean replaceRow(Map rowProperties) {
        String id = (String)rowProperties.get("id");
        if (id == null) {
            throw new IllegalArgumentException("TableData: row's property map does not have an id!");
        }
        if (this.rowIds.contains(id)) {
            this.rows.put(id, rowProperties);
            return this.resetColumnKeys();
        }
        return false;
    }

    public List getColumnKeys() {
        return new ArrayList(this.columnKeys);
    }

    public Vector getColumnNames(Locale locale) {
        Vector<String> names = new Vector<String>(this.columnKeys.size());
        CommonResourceBundle bundle = new CommonResourceBundle(locale);
        Iterator i = this.columnKeys.iterator();
        while (i.hasNext()) {
            names.add(bundle.getString(UIObjectsPropertyLabelKeys.getPropertyLabelKey((String)i.next())));
        }
        return names;
    }

    public List getRowIds() {
        return new ArrayList(this.rowIds);
    }

    public Vector getData() {
        Vector<Vector> rowVector = new Vector<Vector>(this.rowIds.size());
        Iterator i = this.rowIds.iterator();
        while (i.hasNext()) {
            rowVector.add(this.getRowData((String)i.next()));
        }
        return rowVector;
    }

    public Vector getRowData(String id) {
        Map properties = (Map)this.rows.get(id);
        if (properties == null) {
            return null;
        }
        Vector<Object> cols = new Vector<Object>(this.columnKeys.size());
        Object cell = null;
        Iterator i = this.columnKeys.iterator();
        while (i.hasNext()) {
            cell = properties.get(i.next());
            if (cell == null) {
                cell = this.defaultCellObject;
            }
            cols.add(cell);
        }
        return cols;
    }

    public boolean isEmpty() {
        return this.rowIds.isEmpty();
    }

    private boolean resetColumnKeys() {
        List oldKeys = this.columnKeys;
        if (this.rowIds.isEmpty()) {
            this.columnKeys = new ArrayList(0);
            return !oldKeys.isEmpty();
        }
        HashSet availablePropertyKeys = new HashSet();
        Map rowPropertyMap = null;
        Iterator i = this.rows.values().iterator();
        rowPropertyMap = (Map)i.next();
        availablePropertyKeys.addAll(rowPropertyMap.keySet());
        while (i.hasNext()) {
            rowPropertyMap = (Map)i.next();
            if (this.intersectColumns) {
                availablePropertyKeys.retainAll(rowPropertyMap.keySet());
                continue;
            }
            availablePropertyKeys.addAll(rowPropertyMap.keySet());
        }
        this.columnKeys = new ArrayList(this.maxColumnKeys);
        this.columnKeys.retainAll(availablePropertyKeys);
        if (this.columnKeys.isEmpty()) {
            throw new IllegalStateException("There is table data, but no columns in the table!");
        }
        return !((Object)this.columnKeys).equals(oldKeys);
    }
}

